//********************************************************************
//  FahrenheitGUI.java       Author: Lewis/Loftus
//
//  Solution to Programming Project 4.12 (5E, p. 204)
//********************************************************************

import java.awt.Graphics;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.*;
import javax.swing.*;

public class FahrenheitGUI
{
   private int WIDTH = 300;
   private int HEIGHT = 75;

   private JFrame frame;
   private JPanel panel;
   private JLabel inputLabel, outputLabel, resultLabel;
   private JTextField fahrenheit;
   private JButton convertButton;

   //-----------------------------------------------------------------
   //  Sets up the GUI.
   //-----------------------------------------------------------------
   public FahrenheitGUI()
   {
      frame = new JFrame ("Temperature Conversion");
      frame.setDefaultCloseOperation (JFrame.EXIT_ON_CLOSE);

      inputLabel = new JLabel ("Enter Fahrenheit temperature:");
      outputLabel = new JLabel ("Temperature in Celsius: ");
      resultLabel = new JLabel ("---");

      fahrenheit = new JTextField (5);
      fahrenheit.addActionListener (new TempListener());

      convertButton = new JButton("Convert");
      convertButton.addActionListener (new TempListener());
      convertButton.setBackground (Color.yellow);

      panel = new JPanel();
      panel.setPreferredSize (new Dimension(WIDTH, HEIGHT));
      panel.setBackground (Color.yellow);
      panel.add (inputLabel);
      panel.add (fahrenheit);
      panel.add (outputLabel);
      panel.add (resultLabel);
      panel.add(convertButton);

      frame.getContentPane().add (panel);
   }

   //-----------------------------------------------------------------
   //  Displays the primary application frame.
   //-----------------------------------------------------------------
   public void display()
   {
      frame.pack();
      frame.setVisible(true);
   }

   //*****************************************************************
   //  Represents an action listener for the temperature input field.
   //*****************************************************************
   private class TempListener implements ActionListener
   {
      //--------------------------------------------------------------
      //  Performs the conversion when the enter key is pressed in
      //  the text field.
      //--------------------------------------------------------------
      public void actionPerformed (ActionEvent event)
      {
         int fahrenheitTemp, celciusTemp;

         String text = fahrenheit.getText();

         fahrenheitTemp = Integer.parseInt (text);
         celciusTemp = (fahrenheitTemp-32) * 5/9;

         resultLabel.setText (Integer.toString (celciusTemp));
      }
   }
}
